/**
 *
 * \file        nvl.h
 *
 * \brief       Nonvolatile memory class
 *              This handles interfacing to the EEPROM and periodically writing data
 *              according to the timer and flag
 *
 * \author      Adolfo Velasco
 *
 * \date        07/17/08
 *
 */

#ifndef _DM_NVL_H_
#define _DM_NVL_H_

#include "dm_nutypedefs.h"
#include "dm_i2c_eeprom.hpp"

//Video switch timer
#define NVL_SAVE_TIMER_PERIOD_MS           1000      //1 second

//NVL configuration table
struct nvl_config
{
    UINT8* pRamData;                             //Pointer to data structure in RAM
    UINT32 lDataSize;                            //Data structure size (# of bytes)
    const i2c_eeprom_config* pPromConfig;        //EEPROM configuration
};

class nvl
{
public:

    //Constructor
    nvl( const nvl_config* pConfig );

    //Parameter save functions
    void CheckParameterSave( void );
    void SetParameterSave( void );

    //Direct save/load functions
    void Save( void );
    void Load( void );

private:

    //Pointer to configuration table
    const nvl_config* m_pConfig;

    //EEPROM class
    i2c_eeprom* m_pEEPROM;

    //Flag to determine a write
    UINT8 m_bTriggerSave;
};

//Functions
extern void InitNvl( const nvl_config* pConfig );
// MNT - Make the trigger function visible in C files
extern "C"
  {
    void DmTriggerParameterSave( void );
  }

//Pointer to Nvl memory handler
extern nvl* g_pNvlMemory;

#endif  //_DM_NVL_H_
